<?php
/**
 * Plugin Name: Avada – TNC FlipBook – PDF viewer for WordPress Addon
 * Plugin URI: https://codecanyon.net/item/avada-pdf-viewer-for-wordpress-addon/43992846/
 * Description: Use the power of TNC FlipBook - PDF viewer for WordPress right from your Avada Builder.
 * Version: 2.3.0
 * Author: ThemeNcode LLC
 * Author URI: https://themencode.com/
 * Text Domain: avada-pdf-viewer-for-wordpress-addon
 */
/*
 Avada – TNC FlipBook – PDF viewer for WordPress Addon is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 any later version.

 Avada – TNC FlipBook – PDF viewer for WordPress Addon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Avada – TNC FlipBook – PDF viewer for WordPress Addon. If not, see {URI to Plugin License}.
*/

// Plugin Folder Path.
if ( ! defined( 'APDFVW_ADDON_PLUGIN_DIR' ) ) {
	define( 'APDFVW_ADDON_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
/**
 *    Get Plugin Data  
 *     @since 1.0.0
 */


define( 'APDFVW_PVFW_PLUGIN_VERSION', '2.3.0' );

// Include Elements
require_once("include/frontend/avada-pdf-viewer-elements.php");


/**
 * 
 **/


 function apdfvw_display_elements_loaded(){
	if(class_exists('Display_Pdf_Viewer_For_WordPress')) {
		require_once("include/frontend/avada-pdf-display-addon.php");
	 }
 }

 add_action( 'plugins_loaded', 'apdfvw_display_elements_loaded'); 

/**
 * Load plugin textdomain.
 */
function apdfvw_load_textdomain() {
	load_plugin_textdomain('avada-pdf-viewer-for-wordpress-addon',false,plugin_dir_url( __FILE__ ) . "/languages"); 
}

add_action( 'plugins_loaded', 'apdfvw_load_textdomain');

/**
 * Check if plugin is active
 *
 * @param  [type] $plugin [description].
 *
 * @return [type]         [description]
 */
	function apdfvw_avada_is_plugin_active( $plugin ) {
		return in_array( $plugin, (array) get_option( 'active_plugins', array() ) );
	}

	function apdfvw_avada_check_pvfw() {

		if( !apdfvw_avada_is_plugin_active('pdf-viewer-for-wordpress/pdf-viewer-for-wordpress.php') && !apdfvw_avada_is_plugin_active('pdf-viewer-by-themencode/pdf-viewer-by-themencode.php') ) {
			add_action( 'admin_notices', 'apdfvw_avada_pvfw_required');
		}

		
		if( !apdfvw_avada_is_plugin_active('fusion-core/fusion-core.php') || !apdfvw_avada_is_plugin_active('fusion-builder/fusion-builder.php') ) {
			add_action( 'admin_notices', 'apdfvw_fusion_builder_core_pvfw_required');
		}

	}

add_action( 'admin_init', 'apdfvw_avada_check_pvfw' );

/**
 *  Check Pdf Viewer For WordPress plugin active or not
 *  @since 1.0.0
 *
 */
function apdfvw_avada_pvfw_required() {
	$message = sprintf(
		/* translators: 1: Plugin name 2: PDF Viewer for WordPress */
		__( '%1$s requires %2$s or %3$s to be installed and activated.','avada-pdf-viewer-for-wordpress-addon' ),
		'<strong>' . esc_html__( 'Avada TNC FlipBook - PDF Viewer for WordPress Addon', 'avada-pdf-viewer-for-wordpress-addon' ) . '</strong>',
		'<strong><a href="https://codecanyon.net/item/pdf-viewer-for-wordpress/8182815" target="_blank">' . esc_html__( 'TNC FlipBook - PDF Viewer for WordPress', 'avada-pdf-viewer-for-wordpress-addon' ) . '</a></strong>', '<strong><a href="'. admin_url() .'plugin-install.php?tab=plugin-information&plugin=pdf-viewer-by-themencode&TB_iframe=true&width=772&height=858">' . esc_html__( 'TNC PDF Viewer (Free)', 'avada-pdf-viewer-for-wordpress-addon' ) . '</a></strong>' 
	);

	printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

}


/**
 *  Check Fusion Builder plugin and core  plugin active or not
 *  @since 1.0.0
 */

 function apdfvw_fusion_builder_core_pvfw_required(){
    $message = sprintf(
		/* translators: 1: Plugin name 2: PDF Viewer for WordPress */
		__( '%1$s requires %2$s And %3$s to be installed and activated.','avada-pdf-viewer-for-wordpress-addon' ),
		'<strong>' . esc_html__( 'Avada PDF Viewer for WordPress Addon', 'avada-pdf-viewer-for-wordpress-addon' ) . '</strong>',
		'<strong>' . esc_html__( 'Fusion Builder', 'avada-pdf-viewer-for-wordpress-addon' ) . '</strong>', '<strong>' . esc_html__( 'Fusion Core', 'avada-pdf-viewer-for-wordpress-addon' ) . '</strong>' 
	);

	printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
 }


