<?php
	/**
	*  Fusion element PDF Viewer Grid-list 
	*/
	function fusion_element_grid_list() {
		fusion_builder_map( 
			array(
				'name'            => esc_attr__('List/Grid - Display PDF Viewer', 'avada-pdf-viewer-for-wordpress-addon' ),
				'shortcode'       => 'pvfw-list-grid',
				'icon'            => 'fas fa-file-pdf',
				'allow_generator'   => true,
				'params'          => array(
					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Source', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__('Select Source of Viewers','avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'source',
						'value'       => array(
							'all'   		=> esc_attr__('All','avada-pdf-viewer-for-wordpress-addon'),
							'category'      => esc_attr__('By Category','avada-pdf-viewer-for-wordpress-addon'),
							'select-viewer' => esc_attr__('Selected Viewers','avada-pdf-viewer-for-wordpress-addon'),
						),
						'default'	  =>'all',	
					),
					
					array(
						'type'        => 'multiple_select',
						'heading'     => esc_attr__("Select PDF Viewer", 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__("Select PDF Viewers you've already created using PDF Viewer > Add New Menu.", "avada-pdf-viewer-for-wordpress-addon"),
						'param_name'  => 'viewer_id',
						'value'       => avada_get_bookshelf(),
						'dependency'  => [
								[
											'element'  => 'source',
											'value'    => 'select-viewer',
											'operator' => '==',
								],
							],
					),

					array(
						'type'        => 'multiple_select',
						'heading'     => esc_attr__("Select Category", 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__("Select PDF Viewers you've already created using PDF Viewer > Add New Menu.", "avada-pdf-viewer-for-wordpress-addon"),
						'param_name'  => 'category',
						'value'       => avpdf_get_viewer_cats(),
						'dependency'  => [
								[
											'element'  => 'source',
											'value'    => 'category',
											'operator' => '==',
								],
							],
					),
					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Display Type', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__('PDF Viewer Display Type', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'display_type',
						'value'       => array(
							'grid'   => esc_attr__('Grid', 'avada-pdf-viewer-for-wordpress-addon'),
							'list'   => esc_attr__('List', 'avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'grid',
					),
						array(
						'type'        => 'select',
							'heading'     => esc_attr__( 'Open Type', 'avada-pdf-viewer-for-wordpress-addon' ),
							'description' => esc_attr__( 'How the link should open ?', 'avada-pdf-viewer-for-wordpress-addon' ),
							'param_name'  => 'open_type',
							'value'       => array(
								'popup'   => esc_attr__( 'Popup', 'avada-pdf-viewer-for-wordpress-addon'),
								'link'    => esc_attr__( 'Link', 'avada-pdf-viewer-for-wordpress-addon'),
							),
							'default'	  =>'popup',	
						),

						array(
							'type'        => 'select',
							'heading'     => esc_attr__( 'Link Target', 'avada-pdf-viewer-for-wordpress-addon' ),
							'description' => esc_attr__( 'How the link should open ?', 'avada-pdf-viewer-for-wordpress-addon' ),
							'param_name'  => 'link_target',
							'value'       => array(
								'_parent'   => esc_attr__( 'Same Window', 'avada-pdf-viewer-for-wordpress-addon'),
								'_blank'    => esc_attr__( 'New Window', 'avada-pdf-viewer-for-wordpress-addon'),
							),
							'default'	  =>'_parent',	
							'dependency'  => [
								[
									'element'  => 'open_type',
									'value'    => 'link',
									'operator' => '==',
								],
							],
						),

					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Number of Columns', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__('Number of Columns', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'column',
						'value'       => array(
							'col-2'   => esc_attr__('2 column', 'avada-pdf-viewer-for-wordpress-addon'),
							'col-3'   => esc_attr__('3 Column', 'avada-pdf-viewer-for-wordpress-addon'),
							'col-4'   => esc_attr__('4 Column', 'avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'col-3',
					),
					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Enable or disable Filter', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__('Enable or disable Sorting', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'filter',
						'value'       => array(
							'1'   => esc_attr__('On', 'avada-pdf-viewer-for-wordpress-addon'),
							'0'   => esc_attr__('Off', 'avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'1',
						'dependency'  => [
							[
								'element'  => 'display_type',
								'value'    => 'grid',
								'operator' => '==',
							],
						],
					),
					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Enable or disable Sorting', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__('Enable or disable Sorting', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'sort',
						'value'       => array(
							'1'   => esc_attr__('On', 'avada-pdf-viewer-for-wordpress-addon'),
							'0'   => esc_attr__('Off','avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'1',
						'dependency'  => [
							[
								'element'  => 'display_type',
								'value'    => 'grid',
								'operator' => '==',
							],
						],
					),
					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Enable or disable Search', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__('Enable or disable Search', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'search',
						'value'       => array(
							'1'   => esc_attr__('On', 'avada-pdf-viewer-for-wordpress-addon'),
							'0'   => esc_attr__('Off', 'avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'1',
						'dependency'  => [
							[
								'element'  => 'display_type',
								'value'    => 'grid',
								'operator' => '==',
							],
						],
					),
				),	
			) 
		);
	}

add_action('fusion_builder_wp_loaded','fusion_element_grid_list');

/**
 *  Fusion element PDF Viewer bookshelf
 */

function fusion_element_bookshelf() {
	fusion_builder_map( 
		array(
			'name'            => esc_attr__('BookShelf - Display PDF Viewer', 'avada-pdf-viewer-for-wordpress-addon' ),
			'shortcode'       => 'pvfw-book-shelf',
			'icon'            => 'fas fa-file-pdf',
			'allow_generator' => true,
			'params'          => array(
				array(
					'type'        => 'multiple_select',
					'heading'     => esc_attr__("Select PDF Viewer (Cannot select more than 5)", 'avada-pdf-viewer-for-wordpress-addon' ),
					'description' => esc_attr__("Select PDF Viewers you've already created using PDF Viewer > Add New Menu.", "avada-pdf-viewer-for-wordpress-addon"),
					'param_name'  => 'viewer_id',
					'value'       => avada_get_bookshelf(),
					),
					array(
						'type'        => 'select',
						'heading'     => esc_attr__( 'Open Type', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__( 'How the link should open ?', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'open_type',
						'value'       => array(
							'popup'   => esc_attr__( 'Popup', 'avada-pdf-viewer-for-wordpress-addon'),
							'link'    => esc_attr__( 'Link', 'avada-pdf-viewer-for-wordpress-addon'),
						),
						'default'	  =>'popup',	
					),

					array(
						'type'        => 'select',
						'heading'     => esc_attr__( 'Link Target', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__( 'How the link should open ?', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'link_target',
						'value'       => array(
							'_parent'   => esc_attr__( 'Same Window', 'avada-pdf-viewer-for-wordpress-addon'),
							'_blank'    => esc_attr__( 'New Window', 'avada-pdf-viewer-for-wordpress-addon'),
						),
						'default'	  =>'_parent',	
						'dependency'  => [
							[
								'element'  => 'open_type',
								'value'    => 'link',
								'operator' => '==',
							],
						],
					),
					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Shelf Style', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__('Select Shelf Style', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'shelf_type',
						'value'       => array(
							'style-1'   => esc_attr__('Wood Style-1', 'avada-pdf-viewer-for-wordpress-addon'),
							'style-2'   => esc_attr__('Wood Style-2', 'avada-pdf-viewer-for-wordpress-addon'),
							'style-3'   => esc_attr__('Glass Style-1', 'avada-pdf-viewer-for-wordpress-addon'),
							'style-4'   => esc_attr__('Glass Style-2', 'avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'style-1',
					),

					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Order BY ', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'order_by',
						'value'       => array(
							'title'   		=> esc_attr__('Title', 'avada-pdf-viewer-for-wordpress-addon'),
							'name'   		=> esc_attr__('Name', 'avada-pdf-viewer-for-wordpress-addon'),
							'date'   		=> esc_attr__('Date', 'avada-pdf-viewer-for-wordpress-addon'),
							'rand'   		=> esc_attr__('Random', 'avada-pdf-viewer-for-wordpress-addon'),
							'modified'   	=> esc_attr__('Modified', 'avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'date',
					),

					array(
						'type'        => 'select',
						'heading'     => esc_attr__('Order', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'order',
						'value'       => array(
							'ASC'  		=> esc_attr__('Ascending', 'avada-pdf-viewer-for-wordpress-addon'),
							'DESC'      => esc_attr__('Descending', 'avada-pdf-viewer-for-wordpress-addon'),
						),	
						'default'    =>'ASC',
					),


					array(
						'type'        => 'textfield',
						'heading'     => esc_attr__('Css Class', 'avada-pdf-viewer-for-wordpress-addon'),
						'description' => esc_attr__('CSS class to add to the Bookshelf', 'avada-pdf-viewer-for-wordpress-addon'),
						'param_name'  => 'css_class',
					),
			),	
		) 
	);
}
add_action('fusion_builder_wp_loaded','fusion_element_bookshelf');


?>