<?php 
/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
// get id pdf viewer post type 
	function avada_get_viewers() {
			if(post_type_exists('pdfviewer')){
				$avpvfw_options = array();
				$args 		  = array(
					'post_type'      =>'pdfviewer',
					'posts_per_page' => -1,
				);
				$avpvfw_pdfviewers = get_posts($args);
		
		if(! empty($avpvfw_pdfviewers) && ! is_wp_error($avpvfw_pdfviewers)){
			$i = 0;
			foreach ( $avpvfw_pdfviewers as $post ) {
				if ( 0 === $i ) {
					(int) $avpvfw_options[0] = esc_html__( 'Please Select PDF', 'avada-pdf-viewer-for-wordpress-addon');
				}
				(int) $avpvfw_options[ $post->ID ] = $post->post_title;
				$i++;
				}
			}
					
		} else {
		$avpvfw_options = array();
		}
		return $avpvfw_options;
	 } 

		// get id pdf viewer post for bookshelf 

		function avada_get_bookshelf() {
			if(post_type_exists('pdfviewer')){
				$bookshelfvpvfw_options = array();
				$args 		  = array(
					'post_type'      =>'pdfviewer',
					'posts_per_page' => -1,
				);
				$bookshelfvpvfw_pdfviewers = get_posts($args);

		if(! empty($bookshelfvpvfw_pdfviewers) && ! is_wp_error($bookshelfvpvfw_pdfviewers)){
			$i = 0;
			foreach ( $bookshelfvpvfw_pdfviewers as $post ) {
				(int) $bookshelfvpvfw_options[ $post->ID ] = $post->post_title;
				$i++;
				}
			}
					
		} else {
		$bookshelfvpvfw_options = array();
		}
		return $bookshelfvpvfw_options;
		} 
	    /**
		 * Get list of all categories in array
		 */
		function avpdf_get_viewer_cats(){
			$avpdf_get_viewer_cats = get_terms('pdf-cat', array(
				'hide_empty' => false,
			) );
			$avpdf_viewer_cats_list = array();
			if(! empty($avpdf_get_viewer_cats) && ! is_wp_error($avpdf_get_viewer_cats)) {
				foreach ($avpdf_get_viewer_cats as $avpdf_viewer_cat ) {
					$avpdf_viewer_cats_list[$avpdf_viewer_cat->term_id] =  $avpdf_viewer_cat->name;
				}
			}
			
			return $avpdf_viewer_cats_list;
		}

	/**
	 *  Fusion element PDF Viewer Embed/Iframe
	 */
	function fusion_element_pdf_embed() {
		fusion_builder_map( 
			array(
				'name'            => esc_attr__( 'PDF Viewer Embed', 'avada-pdf-viewer-for-wordpress-addon' ),
				'shortcode'       => 'pvfw-embed',
				'icon'            => 'fas fa-file-pdf',
				'params'          => array(
					array(
						'type'        => 'select',
						'heading'     => esc_attr__( 'Select PDF Viewer', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__("Select one of the PDF Viewers you've already created using PDF Viewer > Add New Menu", "avada-pdf-viewer-for-wordpress-addon"),
						'param_name'  => 'viewer_id',
						'value'       => avada_get_viewers(),
						),
					array(
						'type'        => 'textfield',
						'heading'     => esc_attr__('Width', 'avada-pdf-viewer-for-wordpress-addon'),
						'description' => esc_attr__('Width of the Viewer', 'avada-pdf-viewer-for-wordpress-addon'),
						'param_name'  => 'width',
						'value'       => '100%',
						'default'	  => '100%',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_attr__('Height', 'avada-pdf-viewer-for-wordpress-addon'),
						'description' => esc_attr__('Height of the Viewer', 'avada-pdf-viewer-for-wordpress-addon'),
						'param_name'  => 'height',
						'value'       => '800px',
						'default'	  => '800px',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_attr__('Title', 'avada-pdf-viewer-for-wordpress-addon'),
						'description' => esc_attr__('iFrame Title', 'avada-pdf-viewer-for-wordpress-addon'),
						'param_name'  => 'iframe_title',
					),
				),	
			) 
		);
	}
	add_action('fusion_builder_wp_loaded', 'fusion_element_pdf_embed');

	/**
	 *  Fusion element PDF Viewer Link
	 */

	function fusion_element_pdf_link() {
		fusion_builder_map( 
			array(
				'name'            => esc_attr__( 'PDF Viewer Link', 'avada-pdf-viewer-for-wordpress-addon' ),
				'shortcode'       => 'pvfw-link',
				'icon'            => 'fas fa-file-pdf',
				'allow_generator' => true,
				'params'          => array(
					array(
						'type'        => 'select',
						'heading'     => esc_attr__( 'Select PDF Viewer', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__("Select one of the PDF Viewers you've already created using PDF Viewer > Add New Menu", "avada-pdf-viewer-for-wordpress-addon"),
						'param_name'  => 'viewer_id',
						'value'       => avada_get_viewers(),
						),
					array(
						'type'        => 'textfield',
						'heading'     => esc_attr__('Link Class', 'avada-pdf-viewer-for-wordpress-addon'),
						'description' => esc_attr__('Put a css class name here if you want to use any', 'avada-pdf-viewer-for-wordpress-addon'),
						'param_name'  => 'class',
						'value'       => 'tnc_pdf',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_attr__('Link Text', 'avada-pdf-viewer-for-wordpress-addon'),
						'description' => esc_attr__('The Anchor Text', 'avada-pdf-viewer-for-wordpress-addon'),
						'param_name'  => 'text',
						'value'       => esc_attr__( 'Open PDF','avada-pdf-viewer-for-wordpress-addon'),
						'default'	  =>'Open PDF',
					),

					array(
						'type'        => 'select',
						'heading'     => esc_attr__( 'Open Type', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__( 'Select how the content should open in a new link or a popup', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'open_type',
						'value'       => array(
							'link'   => esc_attr__( 'Link', 'avada-pdf-viewer-for-wordpress-addon'),
							'popup'    => esc_attr__( 'Popup', 'avada-pdf-viewer-for-wordpress-addon'),
						),
						'default'	  =>'link',
						
					),

					array(
						'type'        => 'select',
						'heading'     => esc_attr__( 'Link Target', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__( 'How the link should open ?', 'avada-pdf-viewer-for-wordpress-addon' ),
						'param_name'  => 'target',
						'value'       => array(
							'_parent'   => esc_attr__( 'Same Window', 'avada-pdf-viewer-for-wordpress-addon'),
							'_blank'    => esc_attr__( 'New Window', 'avada-pdf-viewer-for-wordpress-addon'),
						),
						'default'	  =>'_parent',
						'dependency'  => [
								[
											'element'  => 'open_type',
											'value'    => 'link',
											'operator' => '==',
								],
							],
					)
				),	
			) 
		);
	}
	add_action( 'fusion_builder_wp_loaded', 'fusion_element_pdf_link');

	/**
	 *  Fusion element PDF Viewer Image Link
	 */

	function fusion_element_image_link() {
		fusion_builder_map( 
			array(
				'name'            => esc_attr__( 'PDF Viewer Image Link', 'avada-pdf-viewer-for-wordpress-addon' ),
				'shortcode'       => 'pvfw-image-link',
				'icon'            => 'fas fa-file-pdf',
				'allow_generator' => true,
				'params'          => array(
					array(
						'type'        => 'select',
						'heading'     => esc_attr__( 'Select PDF Viewer', 'avada-pdf-viewer-for-wordpress-addon' ),
						'description' => esc_attr__("Select one of the PDF Viewers you've already created using PDF Viewer > Add New Menu", "avada-pdf-viewer-for-wordpress-addon"),
						'param_name'  => 'viewer_id',
						'value'       => avada_get_viewers(),
						),
						array(
							'type'        => 'upload',
							'heading'     => esc_attr__( 'Image', 'avada-pdf-viewer-for-wordpress-addon' ),
							'description' => esc_attr__( 'Viewer Image', 'avada-pdf-viewer-for-wordpress-addon' ),
							'param_name'  => 'img_url',
						),
						array(
							'type'        => 'textfield',
							'heading'     => esc_attr__('ALT Text', 'avada-pdf-viewer-for-wordpress-addon'),
							'description' => esc_attr__(' Image Alt Text', 'avada-pdf-viewer-for-wordpress-addon'),
							'param_name'  => 'alt_text',
							'value'	  =>'Image missing. Click here to open PDF file',
							'default'	  =>'Image missing. Click here to open PDF file',
						),

						array(
							'type'        => 'select',
							'heading'     => esc_attr__( 'Open Type', 'avada-pdf-viewer-for-wordpress-addon' ),
							'description' => esc_attr__( 'Select how the content should open in a new link or a popup', 'avada-pdf-viewer-for-wordpress-addon' ),
							'param_name'  => 'open_type',
							'value'       => array(
								'link'   => esc_attr__( 'Link', 'avada-pdf-viewer-for-wordpress-addon'),
								'popup'    => esc_attr__( 'Popup', 'avada-pdf-viewer-for-wordpress-addon'),
							),
							'default'	  =>'link',	
						),

						array(
							'type'        => 'select',
							'heading'     => esc_attr__( 'Link Target', 'avada-pdf-viewer-for-wordpress-addon' ),
							'description' => esc_attr__( 'How the link should open ?', 'avada-pdf-viewer-for-wordpress-addon' ),
							'param_name'  => 'target',
							'value'       => array(
								'_parent'   => esc_attr__( 'Same Window', 'avada-pdf-viewer-for-wordpress-addon'),
								'_blank'    => esc_attr__( 'New Window', 'avada-pdf-viewer-for-wordpress-addon'),
							),
							'default'	  =>'_parent',	
							'dependency'  => [
								[
											'element'  => 'open_type',
											'value'    => 'link',
											'operator' => '==',
								],
							],
						),

						array(
							'type'        => 'textfield',
							'heading'     => esc_attr__('Image Width', 'avada-pdf-viewer-for-wordpress-addon'),
							'description' => esc_attr__('Width of the Image', 'avada-pdf-viewer-for-wordpress-addon'),
							'param_name'  => 'width',
							'value'	  => '100%',
							'default'	  => '100%',
						),
						array(
							'type'        => 'textfield',
							'heading'     => esc_attr__('Image height', 'avada-pdf-viewer-for-wordpress-addon'),
							'description' => esc_attr__('Height of the Image', 'avada-pdf-viewer-for-wordpress-addon'),
							'param_name'  => 'height',
							'value'	      => 'auto',
							'default'	  => 'auto',
						),
						array(
							'type'        => 'select',
							'heading'     => esc_attr__('Image Alignment', 'avada-pdf-viewer-for-wordpress-addon' ),
							'description' => esc_attr__('Image Alignment', 'avada-pdf-viewer-for-wordpress-addon' ),
							'param_name'  => 'alignment',
							'value'       => array(
								' '    => esc_attr__( 'Default', 'avada-pdf-viewer-for-wordpress-addon'),
								'left'    => esc_attr__('left', 'avada-pdf-viewer-for-wordpress-addon'),
								'center'  => esc_attr__( 'Center', 'avada-pdf-viewer-for-wordpress-addon'),
								'right'   => esc_attr__( 'Right', 'avada-pdf-viewer-for-wordpress-addon'),
							),	
							'default'    =>' ',
						),

						array(
							'type'        => 'textfield',
							'heading'     => esc_attr__('Image CSS Class', 'avada-pdf-viewer-for-wordpress-addon'),
							'description' => esc_attr__('CSS Class for the image', 'avada-pdf-viewer-for-wordpress-addon'),
							'param_name'  => 'class',
							'value'       => 'pdf-viewer-image-link-single',
							'default'	  => 'pdf-viewer-image-link-single',
						),
				),	
			) 
		);
	}
add_action( 'fusion_builder_wp_loaded', 'fusion_element_image_link');

	




